import pyMoleCuilder
import os, sys, csv

# check arguments
if len(sys.argv) < 6:
        sys.stderr.write("Usage: "+sys.argv[0]+" <source file> <steps> <server> <port> <workdir> <energyfile> <conformationfile>\n")
        sys.exit(255)

sourcefile=sys.argv[1]
steps=int(sys.argv[2])
serveraddress=sys.argv[3]
serverport=sys.argv[4]
workdir=sys.argv[5]
energyfile=sys.argv[6]
conformationfile=""
if len(sys.argv) >= 7:
	conformationfile=sys.argv[7]

# ========================== Stored Session BEGIN ==========================
pyMoleCuilder.MoleculeLoad(sourcefile)
pyMoleCuilder.ParserSetParserParameters("mpqc", "basis=6-31G;theory=MBPT2;")
energies={}
stepwidth=int(360/steps)
for step in range(0,360,stepwidth):
	pyMoleCuilder.wait()
	# select bond
	pyMoleCuilder.SelectionClearAllAtoms()
	pyMoleCuilder.SelectionAtomByElement("C")
	# advance to next time step
	pyMoleCuilder.WorldStepWorldTime("1")
	# rotate bond
	pyMoleCuilder.MoleculeRotateAroundBond(str(stepwidth), "1")
	# calculate energy	
	pyMoleCuilder.SelectionAllAtoms()
	pyMoleCuilder.FragmentationFragmentation("BondFragment", "3", "2", "1", "1", "", "0", "5", "0", "0", "0")
	pyMoleCuilder.FragmentationFragmentationAutomation(serveraddress, serverport, "", "0", "5", "3", "3", "0", "0", "0", "0", "0")
	pyMoleCuilder.FragmentationAnalyseFragmentationResults("0", "BondFragment", "0")
	# extract energy and place in hash map
	pyMoleCuilder.wait()
	with open(workdir+"/BondFragment_Energy.dat", 'rb') as csvfile:
		energyreader = csv.reader(csvfile, delimiter='\t', quotechar='|')
		for row in energyreader:
			if (row[0]=="2"):
				energies[step]=row[1]
				break
# output all
if len(conformationfile) != 0:
	pyMoleCuilder.WorldOutputAs(conformationfile)
# save energies as csv
with open(energyfile, 'wb') as csvfile:
	energywriter = csv.writer(csvfile, delimiter=',', quotechar='|', quoting=csv.QUOTE_MINIMAL)
	energywriter.writerow(["step", "energy"])
	for key in sorted(energies.keys()):
		energywriter.writerow([str(key), str(energies[key])])
# =========================== Stored Session END ===========================

sys.exit(0)
