import pyMoleCuilder
import os, sys, csv

# check arguments
if len(sys.argv) < 8:
        sys.stderr.write("Usage: "+sys.argv[0]+" <source file> <steps> <basis> <theory> <server> <port> <workdir> <energyfile> <conformationfile>\n")
        sys.exit(255)

order=4
sourcefile=sys.argv[1]
steps=int(sys.argv[2])
basis=sys.argv[3]
theory=sys.argv[4]
serveraddress=sys.argv[5]
serverport=sys.argv[6]
workdir=sys.argv[7]
energyfile=sys.argv[8]
conformationfile=""
if len(sys.argv) >= 9:
	conformationfile=sys.argv[9]

# ========================== Stored Session BEGIN ==========================
pyMoleCuilder.MoleculeLoad(sourcefile)
pyMoleCuilder.ParserSetParserParameters(set_parser_parameters="mpqc", parser_parameters="basis="+basis+";theory="+theory+";do_gradient=no;")
energies={}
stepwidth=int(360/steps)
for step in range(0,360,stepwidth):
	pyMoleCuilder.wait()
	# calculate energy	
	pyMoleCuilder.SelectionAllAtoms()
	pyMoleCuilder.FragmentationFragmentation(fragment_molecule="BondFragment", distance="3", order=str(order), DoSaturate="1", ExcludeHydrogen="1", output_types="", max_meshwidth="0", grid_level="5", inter_order="0", DoCyclesFull="0", parse_state_files="0")
	pyMoleCuilder.FragmentationFragmentationAutomation(server_address=serveraddress, server_port=serverport, fragment_executable="", max_meshwidth="0", grid_level="5", near_field_cells="3", interpolation_degree="3", DoLongrange="0", DoValenceOnly="0", DoPrintDebug="0", DoSmearElectronicCharges="0", UseImplicitCharges="0")
	pyMoleCuilder.FragmentationAnalyseFragmentationResults(store_grids="0", fragment_prefix="BondFragment", UseImplicitCharges="0")
	# extract energy and place in hash map
	pyMoleCuilder.wait()
	with open(workdir+"/BondFragment_Energy.dat", 'rb') as csvfile:
		energyreader = csv.reader(csvfile, delimiter='\t', quotechar='|')
		for row in energyreader:
			if (row[0]==str(order)):
				energies[step]=row[1]
				break
	# select bond
	pyMoleCuilder.SelectionClearAllAtoms()
	pyMoleCuilder.SelectionAtomById("0")
	pyMoleCuilder.SelectionAtomById("1")
	# advance to next time step
	pyMoleCuilder.WorldStepWorldTime("1")
	# rotate bond
	pyMoleCuilder.MoleculeRotateAroundBond(str(stepwidth), "1")
# output all
pyMoleCuilder.ParserSetOutputFormats("tremolo")
pyMoleCuilder.ParserSetTremoloAtomdata(set_tremolo_atomdata="Id type x=3 u=3 F=3 neighbors=4", reset="1")
if len(conformationfile) != 0:
	pyMoleCuilder.WorldOutputAs(conformationfile)
# save energies as csv
with open(energyfile, 'wb') as csvfile:
	energywriter = csv.writer(csvfile, delimiter=',', quotechar='|', quoting=csv.QUOTE_MINIMAL)
	energywriter.writerow(["step", "energy"])
	for key in sorted(energies.keys()):
		energywriter.writerow([str(key), str(energies[key])])
# =========================== Stored Session END ===========================

sys.exit(0)
