/*
 * QtMoleculeItem_name.hpp
 *
 *  Created on: Jan 18, 2015
 *      Author: heber
 */

#ifndef QTMOLECULEITEM_NAME_HPP_
#define QTMOLECULEITEM_NAME_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Views/Qt4/MoleculeList/QtMoleculeItem.hpp"

#include "CodePatterns/ObservedValue.hpp"

#include "Descriptors/MoleculeIdDescriptor.hpp"
#include "molecule.hpp"
#include "World.hpp"

class QtMoleculeItemFactory;

/** This class contains the name of a molecule and keeps it up to date.
 *
 */
class QtMoleculeItem_name : public QtMoleculeItem
{
  //!> only allow factory to instantiate items
  friend class QtMoleculeItemFactory;

  QtMoleculeItem_name(
      const moleculeId_t _molid,
      emitDirtyState_t _emitDirtyState) :
        QtMoleculeItem(_molid, channellist_name, QtMoleculeItem::DoesNotMove, _emitDirtyState),
        molref(getMolecule()),
        name(
            molref,
            boost::bind(&QtMoleculeItem_name::updateName, this),
            "MoleculeItem_name_"+toString(_molid),
            updateName(),
            channellist_name)
  {
    // cannot call pure virtual function in QtMoleculeItem's cstor
    internal_updateState();
  }

  std::string updateName() const
  {
    const molecule * const mol = getMolecule();
    if (mol != NULL)
      return mol->getName();
    else
      return std::string();
  }

  /** Performs the update of the molecule's name.
   *
   */
  void internal_updateState()
  {
    setText(QString(name.get().c_str()));
  }

  QtMoleculeItem::COLUMNTYPES getType() const
  { return QtMoleculeItem::NAME; }

  //!> notification channels of molecule specific to this molecule item, required for update
  static const QtMoleculeItem::channellist_t channellist_name;

  //!> temporary value for molecule
  const molecule * const molref;

  //!> contains visibility state
  ObservedValue<std::string> name;
};


#endif /* QTMOLECULEITEM_NAME_HPP_ */
