/*
 * DryRunAdvocate.hpp
 *
 *  Created on: May 15, 2015
 *      Author: heber
 */

#ifndef DRYRUNADVOCATE_HPP_
#define DRYRUNADVOCATE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Actions/ActionQueue.hpp"

namespace MoleCuilder {

/** Contains all other classes that may access ActionQueue::setDryRun().
 *
 * This is an Advocate design pattern.
 */
class DryRunAdvocate
{
private:
  //! grant respective actions access
  friend class CommandDryRunAction;
  friend class CommandNoDryRunAction;

  static void setDryRun(const bool _dryrun)
  { ActionQueue::getInstance().setDryRun(_dryrun); }
};

} /** namespace MoleCuilder */

#endif /* DRYRUNADVOCATE_HPP_ */
