/*
 * TypeEnumContainer.hpp
 *
 *  Created on: Oct 27, 2010
 *      Author: heber
 */

#ifndef TYPEENUMCONTAINER_HPP_
#define TYPEENUMCONTAINER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <map>
#include <typeinfo>

class TypeEnumContainer {
public:
  TypeEnumContainer();
  ~TypeEnumContainer();

  /** Enumeration of all possible input types.
   *
   */
  enum EnumOfTypes { NoneType,
        BooleanType,
        FileType,
        ListOfFilesType,
        IntegerType,
        ListOfIntegersType,
        UnsignedIntegerType,
        ListOfUnsignedIntegersType,
        DoubleType,
        ListOfDoublesType,
        StringType,
        ListOfStringsType,
        VectorType,
        ListOfVectorsType,
        AtomType,
        ListOfAtomsType,
        MoleculeType,
        ListOfMoleculesType,
        ElementType,
        ListOfElementsType,
        RealSpaceMatrixType
  };

  /** Typedef for map of type_info.
   *
   * Note that typeid always returns lvalue of a static const object, hence we
   * may store its address, see C++ standard 5.2.8.
   *
   */
  typedef std::map< const std::type_info *, enum EnumOfTypes >  type_map;

  enum EnumOfTypes getEnumforType(const std::type_info *_type);

  void ListAllKnownTypes() const;

private:
  // type to enum map for AddOptionToParser()
  type_map TypeEnumMap;
};


#endif /* TYPEENUMCONTAINER_HPP_ */
