/*
 * CommandLineQuery.hpp
 *
 *  Created on: Nov 8, 2010
 *      Author: heber
 */

#ifndef COMMANDLINEQUERY_HPP_
#define COMMANDLINEQUERY_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "CommandLineUI/CommandLineDialog.hpp"

class CommandLineDialog::EmptyCommandLineQuery : public Dialog::EmptyQuery {
public:
  EmptyCommandLineQuery(const std::string &_title, const std::string &_description = "");
  virtual ~EmptyCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::IntCommandLineQuery : public Dialog::TQuery<int> {
public:
  IntCommandLineQuery(Parameter<int> &_param, const std::string &_title, const std::string &_description = "");
  virtual ~IntCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::IntsCommandLineQuery : public Dialog::TQuery<std::vector<int> > {
public:
  IntsCommandLineQuery(Parameter<std::vector<int> > &_param, const std::string &_title, const std::string &_description = "");
  virtual ~IntsCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::UnsignedIntCommandLineQuery : public Dialog::TQuery<unsigned int> {
public:
  UnsignedIntCommandLineQuery(Parameter<unsigned int> &_param, const std::string &_title, const std::string &_description = "");
  virtual ~UnsignedIntCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::UnsignedIntsCommandLineQuery : public Dialog::TQuery<std::vector<unsigned int> > {
public:
  UnsignedIntsCommandLineQuery(Parameter<std::vector<unsigned int> > &_param, const std::string &_title, const std::string &_description = "");
  virtual ~UnsignedIntsCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::BooleanCommandLineQuery : public Dialog::TQuery<bool> {
public:
  BooleanCommandLineQuery(Parameter<bool> &_param, const std::string &_title, const std::string &_description = "");
  virtual ~BooleanCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::DoubleCommandLineQuery : public Dialog::TQuery<double> {
public:
  DoubleCommandLineQuery(Parameter<double> &_param, const std::string &_title, const std::string &_description = "");
  virtual ~DoubleCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::DoublesCommandLineQuery : public Dialog::TQuery<std::vector<double> > {
public:
  DoublesCommandLineQuery(Parameter<std::vector<double> > &_param, const std::string &_title, const std::string &_description = "");
  virtual ~DoublesCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::StringCommandLineQuery : public Dialog::TQuery<std::string> {
public:
  StringCommandLineQuery(Parameter<std::string> &_param, const std::string &_title, const std::string &_description = "");
  virtual ~StringCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::StringsCommandLineQuery : public Dialog::TQuery<std::vector<std::string> > {
public:
  StringsCommandLineQuery(Parameter<std::vector<std::string> > &_param, const std::string &_title, const std::string &_description = "");
  virtual ~StringsCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::AtomCommandLineQuery : public Dialog::TQuery<const atom *> {
public:
  AtomCommandLineQuery(Parameter<const atom *> &_param, const std::string &_title, const std::string &_description = "");
  virtual ~AtomCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::AtomsCommandLineQuery : public Dialog::TQuery<std::vector<const atom*> > {
public:
  AtomsCommandLineQuery(Parameter<std::vector<const atom *> > &_param, const std::string &_title, const std::string &_description = "");
  virtual ~AtomsCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::MoleculeCommandLineQuery : public Dialog::TQuery<const molecule *> {
public:
  MoleculeCommandLineQuery(Parameter<const molecule *> &_param, const std::string &_title, const std::string &_description = "");
  virtual ~MoleculeCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::MoleculesCommandLineQuery : public Dialog::TQuery<std::vector<const molecule*> > {
public:
  MoleculesCommandLineQuery(Parameter<std::vector<const molecule *> > &_param, const std::string &_title, const std::string &_description = "");
  virtual ~MoleculesCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::VectorCommandLineQuery : public Dialog::TQuery<Vector> {
public:
  VectorCommandLineQuery(Parameter<Vector> &_param, const std::string &_title, const std::string &_description = "");
  virtual ~VectorCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::VectorsCommandLineQuery : public Dialog::TQuery<std::vector<Vector> > {
public:
  VectorsCommandLineQuery(Parameter<std::vector<Vector> > &_param, const std::string &_title, const std::string &_description = "");
  virtual ~VectorsCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::RealSpaceMatrixCommandLineQuery : public Dialog::TQuery<RealSpaceMatrix> {
public:
  RealSpaceMatrixCommandLineQuery(Parameter<RealSpaceMatrix> &_param, const std::string &_title, const std::string &_description = "");
  virtual ~RealSpaceMatrixCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::ElementCommandLineQuery : public Dialog::TQuery<const element *> {
public:
  ElementCommandLineQuery(Parameter<const element *> &_param, const std::string &_title, const std::string &_description = "");
  virtual ~ElementCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::ElementsCommandLineQuery : public Dialog::TQuery<std::vector<const element *> > {
public:
  ElementsCommandLineQuery(Parameter<std::vector<const element *> > &_param, const std::string &_title, const std::string &_description = "");
  virtual ~ElementsCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::FileCommandLineQuery : public Dialog::TQuery<boost::filesystem::path> {
public:
  FileCommandLineQuery(Parameter<boost::filesystem::path> &_param, const std::string &_title, const std::string &_description = "");
  virtual ~FileCommandLineQuery();
  virtual bool handle();
};

class CommandLineDialog::FilesCommandLineQuery : public Dialog::TQuery<std::vector<boost::filesystem::path> > {
public:
  FilesCommandLineQuery(Parameter<std::vector< boost::filesystem::path> > &param, const std::string &_title, const std::string &_description = "");
  virtual ~FilesCommandLineQuery();
  virtual bool handle();
};

#endif /* COMMANDLINEQUERY_HPP_ */
