/*
 * MoleculePtrDescriptor.cpp
 *
 *  Created on: Feb 5, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "MoleculePtrDescriptor.hpp"
#include "MoleculePtrDescriptor_impl.hpp"

#include "Patterns/ObservedContainer_impl.hpp"

#include "molecule.hpp"

using namespace std;


MoleculePtrDescriptor_impl::MoleculePtrDescriptor_impl(molecule * _ptr) :
  ptr(_ptr)
{}

MoleculePtrDescriptor_impl::~MoleculePtrDescriptor_impl()
{}

bool MoleculePtrDescriptor_impl::predicate(std::pair<moleculeId_t,molecule*> molecule) {
  return molecule.second==ptr;
}

MoleculeDescriptor MoleculeByPtr(molecule * ptr){
  return MoleculeDescriptor(MoleculeDescriptor::impl_ptr(new MoleculePtrDescriptor_impl(ptr)));
}

molecule *MoleculePtrDescriptor_impl::find(){
  World::MoleculeSet &molecules = getMolecules();
  World::MoleculeSet::iterator res = molecules.find(ptr->getId());
  return (res!=molecules.end())?((*res).second):0;
}

vector<molecule*> MoleculePtrDescriptor_impl::findAll(){
  molecule *res = find();
  return (res)?(vector<molecule*>(1,res)):(vector<molecule*>());
}
