/** \file graph.cpp
 * 
 * Function definitions for the class graph.
 * 
 */

#ifndef GRAPH_HPP_
#define GRAPH_HPP_

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// STL headers
#include <deque>
#include <map>
#include <set>
#include <list>

/****************************************** forward declarations *****************************/

class atom;
class bond;
class config;
class molecule;

class SubGraph;
class Node;
class Edge;
class KeySet;
class UniqueFragments;

/********************************************** definitions *********************************/

typedef std::pair < int, class Node* > NodeMap;
typedef std::multimap < class Node*, class Edge* > EdgeMap;

typedef std::deque<int> KeyStack;
typedef std::pair<int, double> NumberValuePair;


typedef std::map <KeySet, NumberValuePair > Graph;
typedef std::pair <KeySet, NumberValuePair > GraphPair;
typedef std::pair<Graph::iterator, bool> GraphTestPair;


/******************************** Some small functions and/or structures **********************************/

//bool operator < (KeySet SubgraphA, KeySet SubgraphB);   //note: this declaration is important, otherwise normal < is used (producing wrong order)
void InsertGraphIntoGraph(Graph &graph1, Graph &graph2, int *counter);  // Insert all KeySet's in a Graph into another Graph


/********************************************** declarations *******************************/

///** Graph class containing the graphs behind molecules.
// */
//class Graph
//{
//	NodeMap ListOfNodes;		//!< tree-list of all nodes in this graph
//	EdgeMap ListOfEdges;		//!< tree-multi-list of all nodes, referenced to node id
//};
//
///** Class describing subgraphs of the Class \a Graph.
// * SubGraph has its own node and edge lists, however also a pointer to its father graph
// * and hence access to its list as well.
// */
//class SubGraph : class Graph
//{
//	class Graph *FatherGraph;		//!< Graph whose subgraph we are
//};
//
///** Class containing the nodes of a graph.
// */
//class Node
//{
//	int	id;				//!< individual id of the node
//	char *Name;		//!< Name of the node for pretty printing
//};
//
///** Class containing egdes in a Graph strructure.
// */
//class Edge
//{
//	class Node *leftnode;		//!< pointer to first node
//	class Node *atomnode;		//!< pointer to second node
//};



#endif /*GRAPH_HPP_*/
