/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * KeySet.cpp
 *
 *  Created on: Oct 20, 2011
 *      Author: heber
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "KeySet.hpp"

/** Constructor of class KeySet.
 *
 * This class contains a set of indices for the atoms contained in a fragment.
 *
 */
KeySet::KeySet()
{}

/** Destructor of class KeySet.
 *
 */
KeySet::~KeySet()
{}


/** Comparator to allow for placing in a map.
 *
 * @param a instance to compare to
 * @return true - this instance has less items or the first different item itself is less,
 *         false - else
 */
bool KeySet::operator<(const KeySet &a) const
{
  //Log() << Verbose(0) << "my check is used." << endl;
  if (size() < a.size()) {
    return true;
  } else {
    if (size() > a.size()) {
      return false;
    } else {
      KeySet::iterator IteratorA = begin();
      KeySet::iterator IteratorB = a.begin();
      while ((IteratorA != end()) && (IteratorB != a.end())) {
        if ((*IteratorA) <  (*IteratorB))
          return true;
        else if ((*IteratorA) > (*IteratorB)) {
            return false;
          } // else, go on to next index
        IteratorA++;
        IteratorB++;
      } // end of while loop
    }// end of check in case of equal sizes
  }
  return false; // if we reach this point, they are equal
}
