/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * AllAtomsInsideVolumeAction.cpp
 *
 *  Created on: Aug 9, 2010
 *      Author: heber, ankele
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/AtomShapeDescriptor.hpp"
#include "Descriptors/AtomSelectionDescriptor.hpp"
#include "Atom/atom.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "Shapes/ShapeFactory.hpp"
#include "World.hpp"

#include <boost/foreach.hpp>
#include <iostream>
#include <string>

#include "AllAtomsInsideVolumeAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "AllAtomsInsideVolumeAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionAllAtomsInsideVolumeAction::performCall() {
  LOG(1, "Selecting all atoms inside a volume.");
  Shape s = ShapeFactory::getInstance().produce();
  std::vector<atom *> selectedAtoms = World::getInstance().getAllAtoms(AtomsBySelection() && AtomsByShape(s));
  World::getInstance().selectAllAtoms(AtomsByShape(s));
  LOG(0, World::getInstance().countSelectedAtoms() << " atoms selected.");
  return Action::state_ptr(new SelectionAllAtomsInsideVolumeState(selectedAtoms, params));
}

Action::state_ptr SelectionAllAtomsInsideVolumeAction::performUndo(Action::state_ptr _state) {
  SelectionAllAtomsInsideVolumeState *state = assert_cast<SelectionAllAtomsInsideVolumeState*>(_state.get());

  Shape s = ShapeFactory::getInstance().produce();
  World::getInstance().unselectAllAtoms(AtomsByShape(s));
  BOOST_FOREACH(atom *_atom, state->selectedAtoms)
    World::getInstance().selectAtom(_atom);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionAllAtomsInsideVolumeAction::performRedo(Action::state_ptr _state){
  //SelectionAllAtomsInsideVolumeState *state = assert_cast<SelectionAllAtomsInsideVolumeState*>(_state.get());

  Shape s = ShapeFactory::getInstance().produce();
  World::getInstance().selectAllAtoms(AtomsByShape(s));

  return Action::state_ptr(_state);
}

bool SelectionAllAtomsInsideVolumeAction::canUndo() {
  return true;
}

bool SelectionAllAtomsInsideVolumeAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
