/*
 * GLWorldView.hpp
 *
 *  Created on: Auf 11, 2010
 *      Author: heber
 */

#ifndef GLWORLDVIEW_HPP_
#define GLWORLDVIEW_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt3D/qglview.h>

#include "CodePatterns/Observer/Observer.hpp"

#include "World.hpp"

class molecule;
class QKeyEvent;
class GLWorldScene;
class QGLPainter;
class QToolBar;
class QTimer;

/** This class is the view on the 3D representation of the World, i.e. the whole
 * of all molecules (consisting of atoms).
 *
 */
class GLWorldView : public QGLView, public Observer
{
  Q_OBJECT
public:
  GLWorldView(QWidget *parent=0);
  virtual ~GLWorldView();

  void addToolBarActions(QToolBar *toolbar);
  void createDomainBox();
  void createDreiBein();

  // Observer functions
  void update(Observable *publisher);
  void subjectKilled(Observable *publisher);
  void recieveNotification(Observable *publisher, Notification_ptr notification);

public slots:
  void changeSignalled();
  void checkChanges();
  void sceneChangeSignalled();
  void sceneHoverSignalled(const atom &_atom);
  void sceneHoverSignalled(const molecule &_mol, int);
  void changeDreiBein();
  void changeDomain();

signals:
  void changed();
  void TimeChanged();
  void moleculeInserted(const moleculeId_t _id);
  void moleculeRemoved(const moleculeId_t _id);
  void worldSelectionChanged();
  void hoverChanged(const atom &_atom);
  void hoverChanged(const molecule &_mol, int);
  void ShapeAdded();
  void ShapeRemoved();
  void moleculesVisibilityChanged(const moleculeId_t,bool);

protected:
  void initializeGL(QGLPainter *painter);
  void paintGL(QGLPainter *painter);
  void drawDomainBox(QGLPainter *painter) const;
  void drawDreiBein(QGLPainter *painter);

  // input functions
  void mousePressEvent(QMouseEvent *event);
  void mouseMoveEvent(QMouseEvent *event);
  void keyPressEvent(QKeyEvent *event);
  void wheelEvent(QWheelEvent *event);

  // camera functions
  enum CameraControlModeType{
    Rotate,
    Translate
  };

  void setCameraControlMode(CameraControlModeType mode);
  CameraControlModeType getCameraControlMode(bool inverted = false);
public slots:
  void fitCameraToDomain();
  void setCameraControlModeRotation();
  void setCameraControlModeTranslation();
  void setCameraStereoModeDisable();
  void setCameraStereoModeHardware();
  void setCameraStereoModeLeftRight();
  void setCameraStereoModeRightLeft();
  void setCameraStereoModeTopBottom();
  void setCameraStereoModeBottomTop();
  void setCameraStereoModeAnaglyph();

protected:
  CameraControlModeType cameraControlMode;

private:
  void setdreiBeinStatus(const bool status);
  void setDomainStatus(const bool status);

private:

  GLWorldScene *worldscene;

  bool changesPresent;
  bool processingSelectionChanged; // workaround to prevent a loop in (atom_iterator <-> observer)

  QPointF lastMousePos;

  QGLSceneNode *meshDomainBox;
  QGLSceneNode *meshDreiBein;

  QGLMaterial *domainBoxMaterial;
  QGLMaterial *dreiBeinMaterial[3];

  QTimer *redrawTimer;
  bool needsRedraw;

  double defaultEyeSeparation;
};

#endif /* GLWORLDVIEW_HPP_ */
