/*
 * GLWorldScene.hpp
 *
 *  This is based on the Qt3D example "teaservice", specifically parts of teaservice.cpp.
 *
 *  Created on: Aug 17, 2011
 *      Author: heber
 */

#ifndef GLWORLDSCENE_HPP_
#define GLWORLDSCENE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qobject.h>

#include <iosfwd>

#include "Bond/bond.hpp"
#include "GLMoleculeObject_bond.hpp"
#include "GLMoleculeObject_molecule.hpp"
#include "types.hpp"

class atom;
class molecule;
class Shape;

class QGLPainter;
class QGLSceneNode;
class QGLView;

class GLMoleculeObject;
class GLMoleculeObject_atom;
class GLMoleculeObject_molecule;
class GLMoleculeObject_shape;

/** This class contains a list of all molecules in the world.
 *
 */
class GLWorldScene : public QObject
{
  Q_OBJECT
public:
  GLWorldScene(QObject *parent=0);
  virtual ~GLWorldScene();

//#if !defined(QT_OPENGL_ES_1)
//  PerPixelEffect *lighting;
//#endif

  void changeMaterials(bool perPixel);
  QGLSceneNode* getAtom(size_t);
  QGLSceneNode* getMolecule(size_t);
  QGLSceneNode* getBond(size_t, size_t);

  void initialize(QGLView *view, QGLPainter *painter) const;
  void draw(QGLPainter *painter, const QVector4D &cameraPlane) const;

  enum SelectionModeType{
    SelectAtom,
    SelectMolecule
  };
  void setSelectionMode(SelectionModeType mode);

signals:
  void changed();
  void updated();
  void changeOccured();
  void pressed();
  void released();
  void clicked();
  void clicked(atomId_t);
  void doubleClicked();
  void hoverChanged(const atom &);
  void hoverChanged(const molecule &, int);

private slots:
  void atomClicked(atomId_t no);
  void atomInserted(const atomId_t _id);
  void atomRemoved(const atomId_t _id);
  void moleculeClicked(moleculeId_t no);
  void moleculeRemoved(const moleculeId_t _id);
  void moleculeInserted(const moleculeId_t _id);
  void worldSelectionChanged();
  void bondInserted(const bond::ptr _bond, const GLMoleculeObject_bond::SideOfBond side);
  void bondRemoved(const atomId_t leftnr, const atomId_t rightnr);
  void setSelectionModeAtom();
  void setSelectionModeMolecule();
  void changeAtomId(GLMoleculeObject_atom *ob, int oldId, int newOd);
  void addShape();
  void removeShape();
  void update();
  void moleculesVisibilityChanged(const moleculeId_t _id, bool _visible);

public:
  void updateSelectedShapes();

private:
  void init();

private:

  typedef std::map< atomId_t, GLMoleculeObject_molecule* > AtomMoleculeMap;
  typedef std::map< GLMoleculeObject_molecule::BondIds , GLMoleculeObject_molecule* > BondMoleculeMap;
  typedef std::map< moleculeId_t , GLMoleculeObject_molecule* > MoleculeNodeMap;
  typedef std::map< std::string , GLMoleculeObject_shape* > ShapeNodeMap;
  AtomMoleculeMap AtomsinSceneMap;
  BondMoleculeMap BondsinSceneMap;
  MoleculeNodeMap MoleculesinSceneMap;
  ShapeNodeMap ShapesinSceneMap;

  SelectionModeType selectionMode;
};

#endif /* GLWORLDSCENE_HPP_ */
