/*
 * tesselation_boundarytriangleunittest.cpp
 *
 *  Created on: Jan 13, 2010
 *      Author: heber
 */

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include <cstring>

#include "defs.hpp"
#include "tesselation.hpp"
#include "tesselation_boundarytriangleunittest.hpp"

#define SPHERERADIUS 2.

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( TesselationBoundaryTriangleTest );


void TesselationBoundaryTriangleTest::setUp()
{
  setVerbosity(5);

  // create nodes
  TesselPoint *Walker = NULL;
  Walker = new TesselPoint;
  Walker->node = new Vector(0., 0., 0.);
  Walker->Name = Malloc<char>(3, "TesselationBoundaryTriangleTest::setUp - *Name");
  strcpy(Walker->Name, "1");
  Walker->nr = 1;
  points[0] = new BoundaryPointSet(Walker);
  Walker = new TesselPoint;
  Walker->node = new Vector(0., 1., 0.);
  Walker->Name = Malloc<char>(3, "TesselationBoundaryTriangleTest::setUp - *Name");
  strcpy(Walker->Name, "2");
  Walker->nr = 2;
  points[1] = new BoundaryPointSet(Walker);
  Walker = new TesselPoint;
  Walker->node = new Vector(1., 0., 0.);
  Walker->Name = Malloc<char>(3, "TesselationBoundaryTriangleTest::setUp - *Name");
  strcpy(Walker->Name, "3");
  Walker->nr = 3;
  points[2] = new BoundaryPointSet(Walker);

  // create line
  lines[0] = new BoundaryLineSet(points[0], points[1], 0);
  lines[1] = new BoundaryLineSet(points[1], points[2], 1);
  lines[2] = new BoundaryLineSet(points[0], points[2], 2);

  // create triangle
  triangle = new BoundaryTriangleSet(lines, 0);
  triangle->GetNormalVector(Vector(0.,0.,1.));
};


void TesselationBoundaryTriangleTest::tearDown()
{
  delete(triangle);
  MemoryUsageObserver::purgeInstance();
  logger::purgeInstance();
  errorLogger::purgeInstance();
};

/** UnitTest for Tesselation::IsInnerPoint()
 */
void TesselationBoundaryTriangleTest::GetClosestPointOnPlaneTest()
{
  Vector TestIntersection;
  Vector Point;

  // simple test on y line
  Point.Init(-1.,0.5,0.);
  CPPUNIT_ASSERT_EQUAL( 1., triangle->GetClosestPointInsideTriangle(&Point, &TestIntersection) );
  Point.Init(0.,0.5,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );
  Point.Init(-4.,0.5,0.);
  CPPUNIT_ASSERT_EQUAL( 16., triangle->GetClosestPointInsideTriangle(&Point, &TestIntersection) );
  Point.Init(0.,0.5,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );

  // simple test on x line
  Point.Init(0.5,-1.,0.);
  CPPUNIT_ASSERT_EQUAL( 1., triangle->GetClosestPointInsideTriangle(&Point, &TestIntersection) );
  Point.Init(0.5,0.,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );
  Point.Init(0.5,-6.,0.);
  CPPUNIT_ASSERT_EQUAL( 36., triangle->GetClosestPointInsideTriangle(&Point, &TestIntersection) );
  Point.Init(0.5,0.,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );

  // simple test on slanted line
  Point.Init(1.,1.,0.);
  CPPUNIT_ASSERT_EQUAL( 0.5, triangle->GetClosestPointInsideTriangle(&Point, &TestIntersection) );
  Point.Init(0.5,0.5,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );
  Point.Init(5.,5.,0.);
  CPPUNIT_ASSERT_EQUAL( 40.5, triangle->GetClosestPointInsideTriangle(&Point, &TestIntersection) );
  Point.Init(0.5,0.5,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );

  // simple test on first node
  Point.Init(-1.,-1.,0.);
  CPPUNIT_ASSERT_EQUAL( 2., triangle->GetClosestPointInsideTriangle(&Point, &TestIntersection) );
  Point.Init(0.,0.,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );

  // simple test on second node
  Point.Init(0.,2.,0.);
  CPPUNIT_ASSERT_EQUAL( 1., triangle->GetClosestPointInsideTriangle(&Point, &TestIntersection) );
  Point.Init(0.,1.,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );

  // simple test on third node
  Point.Init(2.,0.,0.);
  CPPUNIT_ASSERT_EQUAL( 1., triangle->GetClosestPointInsideTriangle(&Point, &TestIntersection) );
  Point.Init(1.,0.,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );
};

/** UnitTest for Tesselation::IsInnerPoint()
 */
void TesselationBoundaryTriangleTest::GetClosestPointOffPlaneTest()
{
  Vector TestIntersection;
  Vector Point;

  // straight down/up
  Point.Init(1./3.,1./3.,+5.);
  CPPUNIT_ASSERT_EQUAL( 25. , triangle->GetClosestPointInsideTriangle(&Point, &TestIntersection) );
  Point.Init(1./3.,1./3.,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );
  Point.Init(1./3.,1./3.,-5.);
  CPPUNIT_ASSERT_EQUAL( 25. , triangle->GetClosestPointInsideTriangle(&Point, &TestIntersection) );
  Point.Init(1./3.,1./3.,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );

  // simple test on y line
  Point.Init(-1.,0.5,+2.);
  CPPUNIT_ASSERT_EQUAL( 5., triangle->GetClosestPointInsideTriangle(&Point, &TestIntersection) );
  Point.Init(0.,0.5,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );
  Point.Init(-1.,0.5,-3.);
  CPPUNIT_ASSERT_EQUAL( 10., triangle->GetClosestPointInsideTriangle(&Point, &TestIntersection) );
  Point.Init(0.,0.5,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );

  // simple test on x line
  Point.Init(0.5,-1.,+1.);
  CPPUNIT_ASSERT_EQUAL( 2., triangle->GetClosestPointInsideTriangle(&Point, &TestIntersection) );
  Point.Init(0.5,0.,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );
  Point.Init(0.5,-1.,-2.);
  CPPUNIT_ASSERT_EQUAL( 5., triangle->GetClosestPointInsideTriangle(&Point, &TestIntersection) );
  Point.Init(0.5,0.,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );

  // simple test on slanted line
  Point.Init(1.,1.,+3.);
  CPPUNIT_ASSERT_EQUAL( 9.5, triangle->GetClosestPointInsideTriangle(&Point, &TestIntersection) );
  Point.Init(0.5,0.5,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );
  Point.Init(1.,1.,-4.);
  CPPUNIT_ASSERT_EQUAL( 16.5, triangle->GetClosestPointInsideTriangle(&Point, &TestIntersection) );
  Point.Init(0.5,0.5,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );

  // simple test on first node
  Point.Init(-1.,-1.,5.);
  CPPUNIT_ASSERT_EQUAL( 27., triangle->GetClosestPointInsideTriangle(&Point, &TestIntersection) );
  Point.Init(0.,0.,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );

  // simple test on second node
  Point.Init(0.,2.,5.);
  CPPUNIT_ASSERT_EQUAL( 26., triangle->GetClosestPointInsideTriangle(&Point, &TestIntersection) );
  Point.Init(0.,1.,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );

  // simple test on third node
  Point.Init(2.,0.,5.);
  CPPUNIT_ASSERT_EQUAL( 26., triangle->GetClosestPointInsideTriangle(&Point, &TestIntersection) );
  Point.Init(1.,0.,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );
};


/********************************************** Main routine **************************************/

int main(int argc, char **argv)
{
  // Get the top level suite from the registry
  CppUnit::Test *suite = CppUnit::TestFactoryRegistry::getRegistry().makeTest();

  // Adds the test to the list of test to run
  CppUnit::TextUi::TestRunner runner;
  runner.addTest( suite );

  // Change the default outputter to a compiler error format outputter
  runner.setOutputter( new CppUnit::CompilerOutputter( &runner.result(),
                                                       std::cerr ) );
  // Run the tests.
  bool wasSucessful = runner.run();

  // Return error code 1 if the one of test failed.
  return wasSucessful ? 0 : 1;
};
