/*
 * bondgraphunittest.hpp
 *
 *  Created on: Oct 29, 2009
 *      Author: heber
 */

#ifndef BONDGRAPHUNITTEST_HPP_
#define BONDGRAPHUNITTEST_HPP_

#include <cppunit/extensions/HelperMacros.h>


class BondGraph;
class element;
class molecule;
class periodentafel;

/********************************************** Test classes **************************************/

class BondGraphTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( BondGraphTest) ;
    CPPUNIT_TEST ( LoadTableTest );
    CPPUNIT_TEST ( ConstructGraphFromTableTest );
    CPPUNIT_TEST ( ConstructGraphFromCovalentRadiiTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void LoadTableTest();
      void ConstructGraphFromTableTest();
      void ConstructGraphFromCovalentRadiiTest();

private:

      molecule *TestMolecule;
      element *hydrogen;
      element *carbon;
      periodentafel *tafel;

      BondGraph *BG;
      string *filename;
      string *dummyname;
};

#endif /* BONDGRAPHUNITTEST_HPP_ */
