/*
 * LinkedCellUnitTest.hpp
 *
 *  Created on: Apr 9, 2010
 *      Author: heber
 */

#ifndef LINKEDCELLUNITTEST_HPP_
#define LINKEDCELLUNITTEST_HPP_

#include <cppunit/extensions/HelperMacros.h>


class element;
class LinkedCell;
class molecule;
class periodentafel;

/********************************************** Test classes **************************************/

class LinkedCellTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( LinkedCellTest) ;
    CPPUNIT_TEST ( CheckBoundsTest );
    CPPUNIT_TEST ( GetCurrentCellTest );
    CPPUNIT_TEST ( GetRelativeToCurrentCellTest );
    CPPUNIT_TEST ( SetIndexToNodeTest );
    CPPUNIT_TEST ( SetIndexToVectorTest );
    CPPUNIT_TEST ( GetNeighbourBoundsTest );
    CPPUNIT_TEST ( GetallNeighboursTest );
    CPPUNIT_TEST ( GetPointsInsideSphereTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();

      void GetCurrentCellTest();
      void GetRelativeToCurrentCellTest();
      void SetIndexToNodeTest();
      void SetIndexToVectorTest();
      void CheckBoundsTest();
      void GetNeighbourBoundsTest();
      void GetallNeighboursTest();
      void GetPointsInsideSphereTest();

private:

      molecule *TestMolecule;
      element *hydrogen;
      periodentafel *tafel;
      LinkedCell *LC;
};


#endif /* LINKEDCELLUNITTEST_HPP_ */
