/*
 * CountBondsUnitTest.hpp
 *
 *  Created on: Mar 30, 2010
 *      Author: heber
 */

#ifndef COUNTBONDSUNITTEST_HPP_
#define COUNTBONDSUNITTEST_HPP_

#include <cppunit/extensions/HelperMacros.h>


class BondGraph;
class element;
class molecule;
class periodentafel;

/********************************************** Test classes **************************************/

class CountBondsTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( CountBondsTest) ;
    CPPUNIT_TEST ( BondsOfTwoTest );
    CPPUNIT_TEST ( BondsOfThreeTest );
    CPPUNIT_TEST ( HydrogenBridgeBondsTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void BondsOfTwoTest();
      void BondsOfThreeTest();
      void HydrogenBridgeBondsTest();

private:

      MoleculeListClass *molecules;
      molecule *TestMolecule1;
      molecule *TestMolecule2;
      element *hydrogen;
      element *oxygen;
      periodentafel *tafel;

      BondGraph *BG;
      string *filename;
};


#endif /* COUNTBONDSUNITTEST_HPP_ */
