/*
 * config.hpp
 *
 *  Created on: Aug 3, 2009
 *      Author: heber
 */

#ifndef CONFIG_HPP_
#define CONFIG_HPP_

using namespace std;

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "molecules.hpp"
#include "periodentafel.hpp"

/** The config file.
 * The class contains all parameters that control a dft run also functions to load and save.
 */
class config {
  public:
    int PsiType;
    int MaxPsiDouble;
    int PsiMaxNoUp;
    int PsiMaxNoDown;
    int MaxMinStopStep;
    int InitMaxMinStopStep;
    int ProcPEGamma;
    int ProcPEPsi;
    char *configpath;
    char *configname;
    bool FastParsing;
    double Deltat;
    string basis;

    char *databasepath;

    int DoConstrainedMD;
    int MaxOuterStep;
    int Thermostat;
    int *ThermostatImplemented;
    char **ThermostatNames;
    double TempFrequency;
    double alpha;
    double HooverMass;
    double TargetTemp;
    int ScaleTempStep;

  private:
    char *mainname;
    char *defaultpath;
    char *pseudopotpath;

    int DoOutVis;
    int DoOutMes;
    int DoOutNICS;
    int DoOutOrbitals;
    int DoOutCurrent;
    int DoFullCurrent;
    int DoPerturbation;
    int DoWannier;
    int CommonWannier;
    double SawtoothStart;
    int VectorPlane;
    double VectorCut;
    int UseAddGramSch;
    int Seed;

    int OutVisStep;
    int OutSrcStep;
    int MaxPsiStep;
    double EpsWannier;

    int MaxMinStep;
    double RelEpsTotalEnergy;
    double RelEpsKineticEnergy;
    int MaxMinGapStopStep;
    int MaxInitMinStep;
    double InitRelEpsTotalEnergy;
    double InitRelEpsKineticEnergy;
    int InitMaxMinGapStopStep;

    //double BoxLength[NDIM*NDIM];

    double ECut;
    int MaxLevel;
    int RiemannTensor;
    int LevRFactor;
    int RiemannLevel;
    int Lev0Factor;
    int RTActualUse;
    int AddPsis;

    double RCut;
    int StructOpt;
    int IsAngstroem;
    int RelativeCoord;
    int MaxTypes;


  int ParseForParameter(int verbose, ifstream *file, const char *name, int sequential, int const xth, int const yth, int type, void *value, int repetition, int critical);
  int ParseForParameter(int verbose, struct ConfigFileBuffer *FileBuffer, const char *name, int sequential, int const xth, int const yth, int type, void *value, int repetition, int critical);

  public:
  config();
  ~config();

  int TestSyntax(char *filename, periodentafel *periode, molecule *mol);
  void Load(char *filename, periodentafel *periode, molecule *mol);
  void LoadOld(char *filename, periodentafel *periode, molecule *mol);
  void RetrieveConfigPathAndName(string filename);
  bool Save(const char *filename, periodentafel *periode, molecule *mol) const;
  bool SaveMPQC(const char *filename, molecule *mol) const;
  void Edit();
  bool GetIsAngstroem() const;
  char *GetDefaultPath() const;
  void SetDefaultPath(const char *path);
  void InitThermostats(class ConfigFileBuffer *fb);
};

#endif /* CONFIG_HPP_ */
