/*
 * AnalysisCorrelationToSurfaceUnitTest.hpp
 *
 *  Created on: Oct 13, 2009
 *      Author: heber
 */

#ifndef ANALYSISCORRELATIONTOSURFACEUNITTEST_HPP_
#define ANALYSISCORRELATIONTOSURFACEUNITTEST_HPP_

#include <cppunit/extensions/HelperMacros.h>

class element;
class LinkedCell;
class molecule;
class MoleculeListClass;
class periodentafel;
class Tesselation;

/********************************************** Test classes **************************************/

class AnalysisCorrelationToSurfaceUnitTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( AnalysisCorrelationToSurfaceUnitTest ) ;
    CPPUNIT_TEST ( SurfaceTest );
    CPPUNIT_TEST ( CorrelationToSurfaceTest );
    CPPUNIT_TEST ( CorrelationToSurfaceHydrogenBinNoRangeTest );
    CPPUNIT_TEST ( CorrelationToSurfaceHydrogenBinRangeTest );
    CPPUNIT_TEST ( CorrelationToSurfaceCarbonBinNoRangeTest );
    CPPUNIT_TEST ( CorrelationToSurfaceCarbonBinRangeTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void SurfaceTest();
      void CorrelationToSurfaceTest();
      void CorrelationToSurfaceHydrogenBinNoRangeTest();
      void CorrelationToSurfaceHydrogenBinRangeTest();
      void CorrelationToSurfaceCarbonBinNoRangeTest();
      void CorrelationToSurfaceCarbonBinRangeTest();

private:

      std::vector<molecule *> allMolecules;
      molecule *TestSurfaceMolecule;
      const element *hydrogen;
      const element *carbon;
      std::vector<const element *> elements;

      CorrelationToSurfaceMap *surfacemap;
      BinPairMap *binmap;
      Tesselation *Surface;
      LinkedCell *LC;
};

#endif /* ANALYSISCORRELATIONTOSURFACEUNITTEST_HPP_ */
