/*
 * \file FragmentWorker.hpp
 *
 *  Created on: Nov 18, 2011
 *      Author: heber
 */

#ifndef FRAGMENTWORKER_HPP_
#define FRAGMENTWORKER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/asio.hpp>
#include <vector>
#include "Connection.hpp"
#include "FragmentJob.hpp"

/** Receives a job from Server to execute and return FragmentResult.
 *
 */
class FragmentWorker
{
public:
  /// Constructor starts the asynchronous connect operation.
  FragmentWorker(boost::asio::io_service& io_service,
      const std::string& host, const std::string& service);

  /// Handle completion of a connect operation.
  void handle_connect(const boost::system::error_code& e,
      boost::asio::ip::tcp::resolver::iterator endpoint_iterator);

  /// Handle completion of a read operation.
  void handle_read(const boost::system::error_code& e);

private:
  /// The Connection to the server.
  Connection connection_;

  /// The data received from the server.
  std::vector<FragmentJob> jobs_;
};

#endif /* FRAGMENTWORKER_HPP_ */
