/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * FragmentationAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "atom.hpp"
#include "Graph/BondGraph.hpp"
#include "config.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Graph/DepthFirstSearchAnalysis.hpp"
#include "molecule.hpp"
#include "Descriptors/MoleculeDescriptor.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include "Actions/FragmentationAction/FragmentationAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "FragmentationAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr FragmentationFragmentationAction::performCall() {
  clock_t start,end;
  molecule *mol = NULL;
  int ExitFlag = 0;

  // obtain information
  getParametersfromValueStorage();

  DepthFirstSearchAnalysis DFS;
  for (World::MoleculeSelectionConstIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    ASSERT(mol != NULL, "No molecule has been picked for fragmentation.");
    LOG(2, "INFO: Fragmenting molecule with bond distance " << params.distance << " angstroem, order of " << params.order << ".");
    start = clock();
    if (mol->hasBondStructure()) {
      LOG(1, "STAUS: Fragmenting molecule with current connection matrix ...");
      ExitFlag = mol->FragmentMolecule(params.order, params.path, DFS);
    }
    World::getInstance().setExitFlag(ExitFlag);
    end = clock();
    LOG(0, "STATUS: Clocks for this operation: " << (end-start) << ", time: " << ((double)(end-start)/CLOCKS_PER_SEC) << "s.");
  }
  return Action::success;
}

Action::state_ptr FragmentationFragmentationAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr FragmentationFragmentationAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool FragmentationFragmentationAction::canUndo() {
  return true;
}

bool FragmentationFragmentationAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
