/*
 * MoleculeListClass.hpp
 *
 *  Created on: Oct 20, 2011
 *      Author: heber
 */

#ifndef MOLECULELISTCLASS_HPP_
#define MOLECULELISTCLASS_HPP_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iosfwd>
#include <list>
#include <map>
#include <string>

#include "CodePatterns/Observer/Observable.hpp"
#include "CodePatterns/Observer/ObservedIterator.hpp"
#include "CodePatterns/Cacheable.hpp"

#include "Parser/ParserTypes.hpp"
#include "types.hpp"

class molecule;
class periodentafel;
class SortIndex_t;
class World;

typedef std::list<molecule *> MoleculeList;
typedef std::pair<MoleculeList::iterator, bool> MoleculeListTest;


/** A list of \a molecule classes.
 */
class MoleculeListClass : public Observable
{
public:
  MoleculeList ListOfMolecules; //!< List of the contained molecules
  int MaxIndex;

  MoleculeListClass(World *world);
  ~MoleculeListClass();

  bool AddHydrogenCorrection(std::string &path);
  bool StoreForcesFile(std::string &path, const SortIndex_t &SortIndex);
  void insert(molecule *mol);
  void erase(molecule *mol);
  molecule * ReturnIndex(int index);
  bool OutputConfigForListOfFragments(std::string &prefix, ParserTypes type);
  int NumberOfActiveMolecules();
  void Enumerate(std::ostream *out);
  void Output(std::ostream *out);
  int CountAllAtoms() const;

private:
  World *world; //!< The world this List belongs to. Needed to avoid deadlocks in the destructor
};

#endif /* MOLECULELISTCLASS_HPP_ */
