/*
 * SortIndex.hpp
 *
 *  Created on: Sep 20, 2012
 *      Author: heber
 */

#ifndef SORTINDEX_HPP_
#define SORTINDEX_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <map>

#include "types.hpp"

class molecule;

/** This is just a wrapper class meant for refactoring. It emulates a map.
 *
 */
class SortIndex_t
{
public:
  SortIndex_t();
  SortIndex_t(const molecule *mol);

  int find(atomId_t id) const;

private:
  typedef std::map<atomId_t, int> index_t;
  index_t index;
};


#endif /* SORTINDEX_HPP_ */
