/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the COPYING file or "Copyright notice" in builder.cpp for details.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>. 
 */

/*
 * SortIndex.cpp
 *
 *  Created on: Sep 20, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Fragmentation/SortIndex.hpp"

#include "CodePatterns/Assert.hpp"

#include "molecule.hpp"

SortIndex_t::SortIndex_t()
{}

/** Constructor for SortIndex from the internal numbering in a molecule.
 *
 * \param *mol molecule to place in the internal index
 */
SortIndex_t::SortIndex_t(const molecule *mol)
{
  int AtomNo = 0;
  for(molecule::const_iterator iter=mol->begin();iter!=mol->end();++iter){
#ifndef NDEBUG
    std::pair<index_t::iterator, bool> inserter =
#endif
        index.insert( std::make_pair((*iter)->getNr(), AtomNo) );
    ASSERT( inserter.second,
        "SortIndex_t::SortIndex_t() - index "+toString((*iter)->getNr())+" already present.");
    ++AtomNo;
  }
}


int SortIndex_t::find(atomId_t id) const
{
  index_t::const_iterator iter = index.find(id);
  if (iter == index.end())
    return -1;
  else
    return iter->second;
}
