/*
 * ExportGraph_ToFiles.hpp
 *
 *  Created on: 08.03.2012
 *      Author: heber
 */

#ifndef EXPORTGRAPH_TOFILES_HPP_
#define EXPORTGRAPH_TOFILES_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <vector>

#include "Fragmentation/HydrogenSaturation_enum.hpp"
#include "Fragmentation/Exporters/ExportGraph.hpp"
#include "MoleculeListClass.hpp"

class ListOfLocalAtoms_t;

/** ExportGraph_ToFiles implements an ExportGraph as storing all fragmentary
 * systems to files.
 */
class ExportGraph_ToFiles : public ExportGraph
{
public:
	ExportGraph_ToFiles(const Graph &_graph, molecule *&_mol, const enum HydrogenSaturation _saturation);
	virtual ~ExportGraph_ToFiles();

	void operator()();

	void setPrefix(const std::string &_prefix) {
	  prefix = _prefix;
	}

	void setOutputTypes(const std::vector<std::string> &_typelist) {
	  typelist = _typelist;
	}

private:

	void prepareMolecule();
  molecule * StoreFragmentFromKeySet(molecule *mol, KeySet &Leaflet, bool IsAngstroem);
  int StoreFragmentFromKeySet_Init(molecule *mol, molecule *Leaf, KeySet &Leaflet, ListOfLocalAtoms_t &SonList);
  void CreateInducedSubgraphOfFragment(molecule *mol, molecule *Leaf, ListOfLocalAtoms_t &SonList, bool IsAngstroem);

private:
  //!> molecule as reference
  molecule *mol;
  //!> internal list of created molecules
	MoleculeListClass BondFragments;
	//!> prefix for fragment files
	std::string prefix;
  //!> list of parser types for which a configuration file per fragment is stored
  std::vector<std::string> typelist;
  //!> whether to saturate dangling bonds or not
  const enum HydrogenSaturation saturation;
};

#endif /* EXPORTGRAPH_TOFILES_HPP_ */
