/*
 * Bond.hpp
 *
 *  Created on: Aug 3, 2009
 *      Author: heber
 */

#ifndef BOND_HPP_
#define BOND_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Bond/GraphEdge.hpp"

/****************************************** forward declarations *****************************/

class atom;
class ParticleInfo;

/********************************************** declarations *******************************/

/** Bonds between atoms.
 * Class incorporates bonds between atoms in a molecule.
 * Note that we regard bond always as something in a molecule,
 * as it is the glue making up the connected subgraph and
 * hence the molecule. Thus, bonds belong globally to the molecule
 * (and are free'd there) and only locally to the atom class.
 */
class bond : public GraphEdge
{
  public:
  atom *leftatom;    //!< first bond partner
  atom *rightatom;  //!< second bond partner
  int HydrogenBond;  //!< Number of hydrogen atoms in the bond
  int BondDegree;    //!< single, double, triple, ... bond

  atom * GetOtherAtom(const ParticleInfo * const Atom) const;

  bool Contains(const ParticleInfo * const ptr) const;
  bool Contains(const int nr) const;
  double GetDistance() const;
  double GetDistanceSquared() const;

  bond();
  bond(atom *left, atom *right, const int degree=1);
  ~bond();
};

ostream & operator << (ostream &ost, const bond &b);

#endif /* BOND_HPP_ */
