#ifndef helpers_h
#define helpers_h
/** \file helpers.h
 * Header file for \ref helpers.c
 * 
 * Contains declarations of the functions implemented in \ref helpers.c and one
 * inline function which gets current time via an MPI call: GetTime().
 * 
  Project: ParallelCarParrinello
  Jan Hamaekers
  2000

  File: helpers.h
  $Id: helpers.h,v 1.9 2007/02/09 09:13:48 foo Exp $
*/

#include<stddef.h> /* fuer size_t */

// taken out of TREMOLO
/*@-namechecks@*/
#ifndef __GNUC__
# undef __attribute__
# define __attribute__(x)
#endif
/*@=namechecks@*/


/* Behandelt aufgetretene Fehler. error ist der Fehlertyp(enum Errors)
   void *SpecialData ist ein untypisierter Zeiger auf Spezielle Daten zur Fehlerbehandlung.
   Man koennte auch noch einen Zeiger auf eine Funktion uebergeben */
extern void /*@exits@*/ debug(struct Problem *P, const char *output);
  //__attribute__ ((__return__));
#define debug(problemstruct, data) debug_in((problemstruct), (data), __FILE__, __LINE__)

extern void /*@exits@*/ debug_in(struct Problem *P, const char *output,
    const char *file, const int line);
  //__attribute__ ((__return__));

/* Eigene malloc, die bei einem Fehler an Error output uebergibt */
void* Malloc(size_t size, const char* output);

char* MallocString(size_t size, const char* output);

/* Eigene malloc, die bei einem Fehler erzeugten (ein int rein) output  an Error uebergibt */
void* Malloci(size_t size, const char* output, int i);

/* Eigene malloc, die bei einem Fehler erzeugten (zwei int rein) output  an Error uebergibt */
void* Mallocii(size_t size, const char* output, int i, int j);

/* Dasselbe wie oben mit realloc */
void* Realloc(void* pointer, size_t size, const char* output);
void* Realloci(void* pointer, size_t size, const char* output, int i);
void* Reallocii(void* pointer, size_t size, const char* output, int i, int j);
void Free (void *ptr, const char* output);

void GetRGB(int i, unsigned int max, double* rgb);

/** Get current time.
 * Uses MPI_Wtime() to get current system time, synchronously for all processes.
 * \return current time
 */
static inline /*@unused@*/ double GetTime(void)
{
  double t;
  t = MPI_Wtime();
  return t;
};

void InitSpeedMeasure(struct Problem *P);
void SpeedMeasure(struct Problem *P, enum TimeTypes TT, enum TimeDoTypes TOT);
void CompleteSpeedMeasure(struct Problem *P);
void StartParallel (struct Problem *P, char **argv);
void WaitForOtherProcs(struct Problem *P, int out);
/*void SetArrayToDouble0(double *a, int n);*/
void RemoveEverything(struct Problem *P);
#endif
