/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * OutputAsAction.cpp
 *
 *  Created on: Aug 7, 2012
 *      Author: ankele
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Parser/FormatParserStorage.hpp"
#include "Parser/ChangeTracker.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include <boost/filesystem/fstream.hpp>

#include "Actions/WorldAction/OutputAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "OutputAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr WorldOutputAction::performCall() {
  LOG(1, "Storing world to input file.");


  // Parser configured to save anything?
  if (!FormatParserStorage::getInstance().isAbleToSave()){
    STATUS("No parser or file prefix selected.");
    return Action::failure;
  }

  // Save all.
  FormatParserStorage::getInstance().SaveAll();
  ChangeTracker::getInstance().saveStatus();
  return Action::success;
}

ActionState::ptr WorldOutputAction::performUndo(ActionState::ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  STATUS("Undo of WorldOutputAction not implemented.");
  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return ActionState::ptr(new ParserLoadXyzState(state->mol,newName));
}

ActionState::ptr WorldOutputAction::performRedo(ActionState::ptr _state){
  STATUS("Redo of WorldOutputAction not implemented.");
  return Action::failure;
}

bool WorldOutputAction::canUndo() {
  return false;
}

bool WorldOutputAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
