/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * InputAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "molecule.hpp"
#include "MoleculeListClass.hpp"
#include "Parser/FormatParserStorage.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include <boost/filesystem/fstream.hpp>

#include "Actions/WorldAction/InputAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "InputAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr WorldInputAction::performCall() {
//  MoleculeListClass *molecules = World::getInstance().getMolecules();
//  molecule *mol = NULL;
  boost::filesystem::ifstream test;
  FormatParserStorage &parsers = FormatParserStorage::getInstance();

  LOG(0, "Config file given " << params.filename.get() << ".");
  // using the filename as prefix for all parsers
  std::string FilenameSuffix;
  std::string FilenamePrefix;
  if (params.filename.get().has_filename()) {
    // get suffix
    FilenameSuffix = params.filename.get().extension().string().substr(1); // remove the prefixed "."
    FilenamePrefix = params.filename.get().stem().string();
    LOG(1, "Setting config file name prefix to " << FilenamePrefix << ".");
    parsers.SetOutputPrefixForAll(FilenamePrefix);
  } else {
    STATUS("Input file does not have a suffix, cannot recognize format.");
    return Action::failure;
  }

  // parsing file if present
  if (!boost::filesystem::exists(params.filename.get())) {
    LOG(1, "Specified config file " << params.filename.get() << " not found.");
    // DONT FAIL: it's just empty and we use the name. // return Action::failure;
    // nonetheless, add to output formats
    parsers.setOutputFormat( parsers.getTypeFromSuffix(FilenameSuffix) );
  } else {
    LOG(1, "Specified config file found, parsing ... ");

    // parse the file
    test.open(params.filename.get());
    parsers.load(test, FilenameSuffix);
    parsers.setOutputFormat( parsers.getTypeFromSuffix(FilenameSuffix) );
    test.close();

    // set file name of last molecule
    MoleculeList::const_iterator iter = World::getInstance().getMolecules()->ListOfMolecules.end();
    iter--;
    (*iter)->SetNameFromFilename(FilenamePrefix.c_str());
    LOG(0, "Chemical formula is " << (*iter)->getFormula());
  }
  return Action::success;
}

ActionState::ptr WorldInputAction::performUndo(ActionState::ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  STATUS("Undo of WorldInputAction not implemented.");
  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return ActionState::ptr(new ParserLoadXyzState(state->mol,newName));
}

ActionState::ptr WorldInputAction::performRedo(ActionState::ptr _state){
  STATUS("Redo of WorldInputAction not implemented.");
  return Action::failure;
}

bool WorldInputAction::canUndo() {
  return false;
}

bool WorldInputAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
