/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * NonConvexEnvelopeAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "LinkedCell/linkedcell.hpp"
#include "LinkedCell/PointCloudAdaptor.hpp"
#include "molecule.hpp"
#include "Tesselation/boundary.hpp"
#include "Tesselation/tesselation.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include "Actions/TesselationAction/NonConvexEnvelopeAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "NonConvexEnvelopeAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr TesselationNonConvexEnvelopeAction::performCall() {
  molecule * Boundary = NULL;
  bool Success = false;
  clock_t start,end;

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    Boundary = iter->second;
    class Tesselation *T = NULL;
    const LinkedCell_deprecated *LCList = NULL;
    LOG(0, "Evaluating non-convex envelope of molecule." << Boundary->getId());
    LOG(1, "Using rolling ball of radius " << params.SphereRadius.get() << " and storing tecplot data in " << params.filename.get() << ".");
    LOG(1, "Specified molecule has " << Boundary->getAtomCount() << " atoms.");
    start = clock();
    PointCloudAdaptor< molecule > cloud(Boundary, Boundary->name);
    LCList = new LinkedCell_deprecated(cloud, params.SphereRadius.get()*2.);
    Success = FindNonConvexBorder(Boundary, T, LCList, params.SphereRadius.get(), params.filename.get().string().c_str());
    //FindDistributionOfEllipsoids(T, &LCList, N, number, params.filename.get().c_str());
    end = clock();
    LOG(0, "Clocks for this operation: " << (end-start) << ", time: " << ((double)(end-start)/CLOCKS_PER_SEC) << "s.");
    delete(LCList);
    delete(T);
  }
  if (Success)
    return Action::success;
  else
    return Action::failure;
}

ActionState::ptr TesselationNonConvexEnvelopeAction::performUndo(ActionState::ptr _state) {
//  TesselationNonConvexEnvelopeState *state = assert_cast<TesselationNonConvexEnvelopeState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  STATUS("Undo of TesselationNonConvexEnvelopeAction not implemented.");
  return Action::failure;
}

ActionState::ptr TesselationNonConvexEnvelopeAction::performRedo(ActionState::ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool TesselationNonConvexEnvelopeAction::canUndo() {
  return false;
}

bool TesselationNonConvexEnvelopeAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
