/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * NotShapeByNameAction.cpp
 *
 *  Created on: Oct 1, 2012
 *      Author: ankele
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Shapes/ShapeRegistry.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

#include <iostream>
#include <string>

#include "NotShapeByNameAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "NotShapeByNameAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr SelectionNotShapeByNameAction::performCall() {
  const Shape *Walker = ShapeRegistry::getInstance().getByName(params.shapeName.get());
  if (Walker != NULL) {
    if (ShapeRegistry::getInstance().isSelected(params.shapeName.get())) {
      LOG(1, "Unselecting shape " << params.shapeName.get());
      ShapeRegistry::getInstance().unselectShape(params.shapeName.get());
      LOG(0, ShapeRegistry::getInstance().countSelectedShapes() << " shapes remain selected.");
      return ActionState::ptr(new SelectionNotShapeByNameState(params));
    } else {
      return Action::success;
    }
  } else {
    STATUS("Cannot find shape by given name "+toString(params.shapeName.get())+".");
    return Action::failure;
  }
}

ActionState::ptr SelectionNotShapeByNameAction::performUndo(ActionState::ptr _state) {
  SelectionNotShapeByNameState *state = assert_cast<SelectionNotShapeByNameState*>(_state.get());

  ShapeRegistry::getInstance().selectShape(state->params.shapeName.get());

  return ActionState::ptr(_state);
}

ActionState::ptr SelectionNotShapeByNameAction::performRedo(ActionState::ptr _state){
  SelectionNotShapeByNameState *state = assert_cast<SelectionNotShapeByNameState*>(_state.get());

  ShapeRegistry::getInstance().unselectShape(state->params.shapeName.get());

  return ActionState::ptr(_state);
}

bool SelectionNotShapeByNameAction::canUndo() {
  return true;
}

bool SelectionNotShapeByNameAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
