/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * NotMoleculeByIdAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "molecule.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Descriptors/MoleculeIdDescriptor.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include "NotMoleculeByIdAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "NotMoleculeByIdAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr SelectionNotMoleculeByIdAction::performCall() {
  const molecule *mol = World::getInstance().getMolecule(MoleculeById(params.molindex.get()));
  if (mol != NULL) {
    if (World::getInstance().isSelected(mol)) {
      LOG(1, "Unselecting molecule " << mol->name);
      World::getInstance().unselectAllMolecules(MoleculeById(params.molindex.get()));
      LOG(0, World::getInstance().countSelectedMolecules() << " molecules remain selected.");
      return ActionState::ptr(new SelectionNotMoleculeByIdState(params));
    } else {
      return Action::success;
    }
  } else {
    STATUS("Cannot find molecule by given index "+toString(params.molindex.get())+".");
    return Action::failure;
  }
}

ActionState::ptr SelectionNotMoleculeByIdAction::performUndo(ActionState::ptr _state) {
  SelectionNotMoleculeByIdState *state = assert_cast<SelectionNotMoleculeByIdState*>(_state.get());

  World::getInstance().selectAllMolecules(MoleculeById(state->params.molindex.get()));

  return ActionState::ptr(_state);
}

ActionState::ptr SelectionNotMoleculeByIdAction::performRedo(ActionState::ptr _state){
  SelectionNotMoleculeByIdState *state = assert_cast<SelectionNotMoleculeByIdState*>(_state.get());

  World::getInstance().unselectAllMolecules(MoleculeById(state->params.molindex.get()));

  return ActionState::ptr(_state);
}

bool SelectionNotMoleculeByIdAction::canUndo() {
  return true;
}

bool SelectionNotMoleculeByIdAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
