/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * AtomByOrderAction.cpp
 *
 *  Created on: Mar 22, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Atom/atom.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"
#include "Descriptors/AtomIdDescriptor.hpp"
#include "Descriptors/AtomOrderDescriptor.hpp"

#include <iostream>
#include <string>

#include "AtomByOrderAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "AtomByOrderAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr SelectionAtomByOrderAction::performCall() {
  const atom *Walker = World::getInstance().getAtom(AtomByOrder(params.order.get()));
  if (Walker != NULL) {
    if (!World::getInstance().isSelected(Walker)) {
      LOG(1, "Selecting atom " << *Walker);
      World::getInstance().selectAtom(Walker);
      LOG(0, World::getInstance().countSelectedAtoms() << " atoms selected.");
      return ActionState::ptr(new SelectionAtomByOrderState(Walker->getId(), params));
    } else {
      return Action::success;
    }
  } else {
    STATUS("Cannot find atom by given order of "+toString(params.order.get())+".");
    return Action::failure;
  }
}

ActionState::ptr SelectionAtomByOrderAction::performUndo(ActionState::ptr _state) {
  SelectionAtomByOrderState *state = assert_cast<SelectionAtomByOrderState*>(_state.get());

  const atom *Walker = World::getInstance().getAtom(AtomById(state->WalkerId));
  World::getInstance().unselectAtom(Walker);

  return ActionState::ptr(_state);
}

ActionState::ptr SelectionAtomByOrderAction::performRedo(ActionState::ptr _state){
  SelectionAtomByOrderState *state = assert_cast<SelectionAtomByOrderState*>(_state.get());

  const atom *Walker = World::getInstance().getAtom(AtomById(state->WalkerId));
  World::getInstance().selectAtom(Walker);

  return ActionState::ptr(_state);
}

bool SelectionAtomByOrderAction::canUndo() {
  return true;
}

bool SelectionAtomByOrderAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
