/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * AllAtomsInsideVolumeAction.cpp
 *
 *  Created on: Aug 9, 2010
 *      Author: heber, ankele
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/AtomShapeDescriptor.hpp"
#include "Descriptors/AtomSelectionDescriptor.hpp"
#include "Atom/atom.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "Shapes/ShapeRegistry.hpp"
#include "World.hpp"

#include <boost/foreach.hpp>
#include <iostream>
#include <string>

#include "AllAtomsInsideVolumeAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "AllAtomsInsideVolumeAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr SelectionAllAtomsInsideVolumeAction::performCall() {
  LOG(1, "Selecting all atoms inside a volume.");
  std::vector<Shape*> selectedShapes = ShapeRegistry::getInstance().getSelectedShapes();
  if (selectedShapes.size() != 1){
    STATUS("There has to be exactly 1 selected shape.");
    return Action::failure;
  }
  std::vector<atom *> selectedAtoms = World::getInstance().getAllAtoms(AtomsBySelection());
  World::getInstance().selectAllAtoms(AtomsByShape(*selectedShapes[0]));
  LOG(0, World::getInstance().countSelectedAtoms() << " atoms selected.");
  return ActionState::ptr(new SelectionAllAtomsInsideVolumeState(selectedAtoms, params));
}

ActionState::ptr SelectionAllAtomsInsideVolumeAction::performUndo(ActionState::ptr _state) {
  SelectionAllAtomsInsideVolumeState *state = assert_cast<SelectionAllAtomsInsideVolumeState*>(_state.get());

  std::vector<Shape*> selectedShapes = ShapeRegistry::getInstance().getSelectedShapes();
  World::getInstance().unselectAllAtoms(AtomsByShape(*selectedShapes[0]));
  BOOST_FOREACH(atom *_atom, state->selectedAtoms)
    World::getInstance().selectAtom(_atom);

  return ActionState::ptr(_state);
}

ActionState::ptr SelectionAllAtomsInsideVolumeAction::performRedo(ActionState::ptr _state){
  //SelectionAllAtomsInsideVolumeState *state = assert_cast<SelectionAllAtomsInsideVolumeState*>(_state.get());

  std::vector<Shape*> selectedShapes = ShapeRegistry::getInstance().getSelectedShapes();
  World::getInstance().selectAllAtoms(AtomsByShape(*selectedShapes[0]));

  return ActionState::ptr(_state);
}

bool SelectionAllAtomsInsideVolumeAction::canUndo() {
  return true;
}

bool SelectionAllAtomsInsideVolumeAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
