/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * SaveHomologiesAction.cpp
 *
 *  Created on: Jun 24, 2013
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include headers that implement a archive in simple text format
// and before MemDebug due to placement new
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include "CodePatterns/Log.hpp"

#include "Fragmentation/Homology/HomologyContainer.hpp"
#include "World.hpp"

#include "Actions/PotentialAction/SaveHomologiesAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "SaveHomologiesAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */

bool writeHomologiesToFile(
    const boost::filesystem::path &homology_file
    )
{
  /// store homology container again
  HomologyContainer &homology_container = World::getInstance().getHomologies();
  std::ofstream outputstream(homology_file.string().c_str());
  if (outputstream.good()) { // check if opened
    boost::archive::text_oarchive oa(outputstream);
    oa << homology_container;
    if (outputstream.fail()) { // check if correctly written
      LOG(1, "Failed to write to file " << homology_file.string() << ".");
      return false;
    } else
      outputstream.close();
  } else {
    LOG(1, "Failed to open file " << homology_file.string()
        << " for writing.");
    return false;
  }
  return true;
}

ActionState::ptr PotentialSaveHomologiesAction::performCall()
{
  if (!params.homology_file.get().empty()) {
    const boost::filesystem::path &homology_file = params.homology_file.get();
    LOG(1, "INFO: Appending HomologyGraphs to file " << homology_file.string() << ".");
    if (!writeHomologiesToFile(homology_file)) {
      STATUS("Failed to write homology file.");
      return Action::failure;
    }
    return Action::success;
  } else {
    STATUS("Homology file name empty.");
    return Action::failure;
  }
}

ActionState::ptr PotentialSaveHomologiesAction::performUndo(ActionState::ptr _state) {
  return Action::success;
}

ActionState::ptr PotentialSaveHomologiesAction::performRedo(ActionState::ptr _state){
  return Action::success;
}

bool PotentialSaveHomologiesAction::canUndo() {
  return false;
}

bool PotentialSaveHomologiesAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
