/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ParseHomologiesAction.cpp
 *
 *  Created on: Jun 24, 2013
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include headers that implement a archive in simple text format
// and before MemDebug due to placement new
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include "CodePatterns/Log.hpp"

#include "Fragmentation/Homology/HomologyContainer.hpp"
#include "World.hpp"

#include "Actions/PotentialAction/ParseHomologiesAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "ParseHomologiesAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */

void parseHomologiesFromFile(
    const boost::filesystem::path &homology_file
    )
{
  HomologyContainer &homology_container = World::getInstance().getHomologies();
  if (boost::filesystem::exists(homology_file)) {
    std::ifstream returnstream(homology_file.string().c_str());
    if (returnstream.good()) {
      boost::archive::text_iarchive ia(returnstream);
      ia >> homology_container;
    } else {
      ELOG(2, "Failed to parse from " << homology_file.string() << ".");
    }
    returnstream.close();
  } else {
    LOG(2, "Could not open " << homology_file.string()
        << ", creating empty container.");
  }
}

ActionState::ptr PotentialParseHomologiesAction::performCall()
{
  // append all keysets to homology file
  if (!params.homology_file.get().empty()) {
    const boost::filesystem::path &homology_file = params.homology_file.get();
    LOG(1, "INFO: Parsing HomologyGraphs from file " << homology_file.string() << ".");
    parseHomologiesFromFile(homology_file);
    return Action::success;
  } else {
    STATUS("Homology file name is empty.");
    return Action::failure;
  }
}

ActionState::ptr PotentialParseHomologiesAction::performUndo(ActionState::ptr _state) {
  STATUS("Undo of PotentialParseHomologiesAction not implemented.");
  return Action::failure;
}

ActionState::ptr PotentialParseHomologiesAction::performRedo(ActionState::ptr _state){
  STATUS("Redo of PotentialParseHomologiesAction not implemented.");
  return Action::failure;
}

bool PotentialParseHomologiesAction::canUndo() {
  return false;
}

bool PotentialParseHomologiesAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
