/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * SetOutputFormatsAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Parser/ChangeTracker.hpp"
#include "Parser/FormatParserStorage.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include "SetOutputFormatsAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "SetOutputFormatsAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr ParserSetOutputFormatsAction::performCall() {
  LOG(1, "Format list is: " << params.FormatList.get());
  for (vector<std::string>::const_iterator iter = params.FormatList.get().begin(); iter != params.FormatList.get().end(); ++iter) {
    if (!FormatParserStorage::getInstance().add(*iter)) {
      STATUS("Unknown parser format in ParserSetOutputFormatsAction: '"+*iter+"'");
      return Action::failure;
    } else {
      FormatParserStorage::getInstance().setOutputFormat(*iter);
    }
  }
  return Action::success;
}

ActionState::ptr ParserSetOutputFormatsAction::performUndo(ActionState::ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  STATUS("Undo of ParserSetOutputFormatsAction not implemented.");
  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return ActionState::ptr(new ParserLoadXyzState(state->mol,newName));
}

ActionState::ptr ParserSetOutputFormatsAction::performRedo(ActionState::ptr _state){
  STATUS("Redo of ParserSetOutputFormatsAction not implemented.");
  return Action::failure;
}

bool ParserSetOutputFormatsAction::canUndo() {
  return false;
}

bool ParserSetOutputFormatsAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
