/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * SaveSelectedAtomsAsExtTypesAction.cpp
 *
 *  Created on: Apr 4, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Parser/TremoloParser.hpp"
#include "Parser/FormatParserStorage.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include <boost/filesystem/fstream.hpp>

#include "SaveSelectedAtomsAsExtTypesAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "SaveSelectedAtomsAsExtTypesAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr ParserSaveSelectedAtomsAsExtTypesAction::performCall() {
  if (boost::filesystem::exists(params.filename.get())) {
    STATUS("Specified exttypes file "+params.filename.get().string()+" already exists.");

    return Action::failure;
  } else {
    const FormatParser<tremolo> &parser = FormatParserStorage::getInstance().getParser<tremolo>();

    LOG(1, "Creating exttypes file " << params.filename.get() << " ... ");
    boost::filesystem::ofstream test;
    test.open(params.filename.get());
    const bool status = parser.saveAtomsInExttypes(test, World::getInstance().getSelectedAtoms(), params.id.get());
    test.close();

    if (status)
      return Action::success;
    else {
      STATUS("Failed to write ext file.");
      return Action::failure;
    }
  }
}

ActionState::ptr ParserSaveSelectedAtomsAsExtTypesAction::performUndo(ActionState::ptr _state) {
  return Action::success;
}

ActionState::ptr ParserSaveSelectedAtomsAsExtTypesAction::performRedo(ActionState::ptr _state){
  return Action::success;
}

bool ParserSaveSelectedAtomsAsExtTypesAction::canUndo() {
  return true;
}

bool ParserSaveSelectedAtomsAsExtTypesAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
