/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * VerletIntegrationAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Atom/atom.hpp"
#include "Atom/AtomSet.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Dynamics/VerletForceIntegration.hpp"
#include "molecule.hpp"
#include "World.hpp"
#include "WorldTime.hpp"

#include <vector>
#include <iostream>
#include <fstream>
#include <string>

#include "Actions/MoleculeAction/VerletIntegrationAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "VerletIntegrationAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr MoleculeVerletIntegrationAction::performCall() {
  // TODO: sollte besser stream nutzen, nicht filename direkt (es sei denn, ist prefix), besser fuer unit test
  AtomSetMixin<std::vector<atom *> > set(World::getInstance().getSelectedAtoms());
  // we always operate relative to current time step
  size_t CurrentStep = WorldTime::getInstance().getTime();
  VerletForceIntegration<std::vector<atom *> > Verlet(set, params.Deltat.get(), true);
  // parse forces into next step
  if (!params.forcesfile.get().string().empty()) {
    LOG(1, "Parsing forces file.");
    if (!Verlet.parseForcesFile(params.forcesfile.get().string().c_str(), CurrentStep))
      LOG(2, "File " << params.forcesfile.get() << " not found.");
    else
      LOG(2, "File " << params.forcesfile.get() << " found and parsed.");
  }
  // perform velocity verlet update
  LOG(1, "Verlet integrating.");
  if (!Verlet(CurrentStep+1, 1, 0, params.FixedCenterOfMass.get()))
    ELOG(1, "Velocity verlet failed.");
  else
    LOG(2, "DEBUG: Successfully performed updates on velocity and position.");
  // increment to next time step
  World::getInstance().setTime(CurrentStep+1);

  return Action::success;
}

ActionState::ptr MoleculeVerletIntegrationAction::performUndo(ActionState::ptr _state) {
//  MoleculeVerletIntegrationState *state = assert_cast<MoleculeVerletIntegrationState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  STATUS("Undo of MoleculeVerletIntegrationAction not implemented.");
  return Action::failure;
}

ActionState::ptr MoleculeVerletIntegrationAction::performRedo(ActionState::ptr _state){
  STATUS("Rddo of MoleculeVerletIntegrationAction not implemented.");
  return Action::failure;
}

bool MoleculeVerletIntegrationAction::canUndo() {
  return true;
}

bool MoleculeVerletIntegrationAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
