/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * SuspendInWaterAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "Tesselation/boundary.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include "Actions/MoleculeAction/SuspendInWaterAction.hpp"

class config;

using namespace MoleCuilder;

// and construct the stuff
#include "SuspendInWaterAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr MoleculeSuspendInWaterAction::performCall() {
  molecule *mol = NULL;
  double volume = 0.;

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    LOG(0, "Evaluating necessary cell volume for a cluster suspended in water.");
    if (params.density.get() < 1.0) {
      ELOG(1, "Density must be greater than 1.0g/cm^3!");
    } else {
      PrepareClustersinWater(World::getInstance().getConfig(), mol, volume, params.density.get());  // if volume == 0, will calculate from ConvexEnvelope
    }
  }
  return Action::success;
}

ActionState::ptr MoleculeSuspendInWaterAction::performUndo(ActionState::ptr _state) {
//  MoleculeSuspendInWaterState *state = assert_cast<MoleculeSuspendInWaterState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  STATUS("Undo of MoleculeSuspendInWaterAction not implemented.");
  return Action::failure;
}

ActionState::ptr MoleculeSuspendInWaterAction::performRedo(ActionState::ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeSuspendInWaterAction::canUndo() {
  return false;
}

bool MoleculeSuspendInWaterAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
