/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ChangeNameAction.cpp
 *
 *  Created on: Jan 15, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Atom/atom.hpp"
#include "molecule.hpp"

#include <iostream>
#include <string>

#include "Actions/MoleculeAction/ChangeNameAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "ChangeNameAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr MoleculeChangeNameAction::performCall() {
  molecule *mol = NULL;

  if (World::getInstance().countSelectedMolecules() == 1) {
    mol = World::getInstance().beginMoleculeSelection()->second;
    string oldName = mol->getName();
    mol->setName(params.name.get());
    return ActionState::ptr(new MoleculeChangeNameState(mol,params));
  } else {
    STATUS("There must be exactly one molecule selected.");
    return Action::failure;
  }
}

ActionState::ptr MoleculeChangeNameAction::performUndo(ActionState::ptr _state) {
  MoleculeChangeNameState *state = assert_cast<MoleculeChangeNameState*>(_state.get());

  string newName = state->mol->getName();
  state->mol->setName(state->params.name.get());
  state->params.name.set(newName);

  return ActionState::ptr(_state);
}

ActionState::ptr MoleculeChangeNameAction::performRedo(ActionState::ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeChangeNameAction::canUndo() {
  return true;
}

bool MoleculeChangeNameAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
