/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * BondFileAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Graph/BondGraph.hpp"
#include "CodePatterns/Log.hpp"
#include "molecule.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <fstream>
#include <string>

#include "Actions/MoleculeAction/BondFileAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "BondFileAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr MoleculeBondFileAction::performCall() {
  molecule *mol = NULL;

  if(World::getInstance().countSelectedMolecules() == 1) {
    mol = World::getInstance().beginMoleculeSelection()->second;
    LOG(0, "STATUS: Parsing bonds from " << params.bondfile.get()
        << ", skipping " << params.skiplines.get() << "lines"
        << ", adding " << params.id_offset.get() << " to each id.");
    ifstream input(params.bondfile.get().string().c_str());
    World::AtomComposite Set = mol->getAtomSet();
    World::getInstance().getBondGraph()->CreateAdjacencyListFromDbondFile(Set, &input, params.skiplines.get(), params.id_offset.get());
    input.close();
    mol->getBondCount();
    return Action::success;
  } else {
    STATUS("There is not exactly one molecule selected.");
    return Action::failure;
  }
}

ActionState::ptr MoleculeBondFileAction::performUndo(ActionState::ptr _state) {
//  MoleculeBondFileState *state = assert_cast<MoleculeBondFileState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  STATUS("Undo for MoleculeBondFileAction not implemented.");
  return Action::failure;
}

ActionState::ptr MoleculeBondFileAction::performRedo(ActionState::ptr _state){
  STATUS("Redo for MoleculeBondFileAction not implemented.");
  return Action::failure;
}

bool MoleculeBondFileAction::canUndo() {
  return true;
}

bool MoleculeBondFileAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
