/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2013 University of Bonn. All rights reserved.
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * StoreSaturatedFragmentAction.cpp
 *
 *  Created on: Feb 26, 2013
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Atom/atom.hpp"
#include "CodePatterns/Log.hpp"
#include "Fragmentation/Exporters/ExportGraph_ToFiles.hpp"
#include "Fragmentation/Graph.hpp"
#include "World.hpp"

#include <boost/filesystem.hpp>
#include <algorithm>
#include <iostream>
#include <string>

#include "Actions/FragmentationAction/StoreSaturatedFragmentAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "StoreSaturatedFragmentAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr FragmentationStoreSaturatedFragmentAction::performCall() {
  World &world = World::getInstance();

  // check for selected atoms
  if (world.beginAtomSelection() == world.endAtomSelection()) {
    STATUS("There are not atoms selected for storing.");
    return Action::failure;
  }

  // create single graph from selected atoms
  Graph TotalGraph;
  KeySet SelectedAtoms;
  for (World::AtomSelectionConstIterator iter = world.beginAtomSelection();
      iter != world.endAtomSelection();
      ++iter) {
    LOG(3, "DEBUG: Adding atom " << *iter->second << " to fragment.");
    SelectedAtoms.insert( iter->second->getId() );
  }
  TotalGraph.insert( GraphPair( SelectedAtoms, NumberValuePair(1, 0.)) );

  // store molecule's fragment to file
  {
    const enum HydrogenSaturation saturation =  params.DoSaturation.get() ? DoSaturate : DontSaturate;
    ExportGraph_ToFiles exporter(TotalGraph, IncludeHydrogen, saturation);
    exporter.setPrefix(params.prefix.get());
    exporter.setOutputTypes(params.types.get());
    exporter();
  }

  return Action::success;
}

ActionState::ptr FragmentationStoreSaturatedFragmentAction::performUndo(ActionState::ptr _state) {
  return Action::success;
}

ActionState::ptr FragmentationStoreSaturatedFragmentAction::performRedo(ActionState::ptr _state){
  return Action::success;
}

bool FragmentationStoreSaturatedFragmentAction::canUndo() {
  return true;
}

bool FragmentationStoreSaturatedFragmentAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
