/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * VersionAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "version.h"

#include <iostream>
#include <string>

#include "Actions/CommandAction/VersionAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "VersionAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr CommandVersionAction::performCall() {
  STATUS("Version of the program is "+toString(MOLECUILDERVERSION)+".");
  return Action::success;
}

ActionState::ptr CommandVersionAction::performUndo(ActionState::ptr _state) {
  return Action::success;
}

ActionState::ptr CommandVersionAction::performRedo(ActionState::ptr _state){
  return Action::success;
}

bool CommandVersionAction::canUndo() {
  return true;
}

bool CommandVersionAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
