/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * LoadSessionAction.cpp
 *
 *  Created on: Aug 26, 2013
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// boost::python uses placement new which is incompatible with MemDebug.
#ifdef HAVE_PYTHON
#include "Python/PythonScripting.hpp"
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"

#include <fstream>

#include "Actions/CommandAction/LoadSessionAction.hpp"
#include "Actions/ActionQueue.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "LoadSessionAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr CommandLoadSessionAction::performCall() {

  LOG(1, "INFO: Loading session from file " << params.filename.get().string());

#ifdef HAVE_PYTHON
  if (executePythonScript(params.filename.get().string()))
    return Action::success;
  else {
    STATUS("Failed executing python script.");
    return Action::failure;
  }
#else
  STATUS("Python capabilities have not been compiled in.");
  return Action::failure;
#endif


}

ActionState::ptr CommandLoadSessionAction::performUndo(ActionState::ptr _state) {
//  CommandLoadSessionState *state = assert_cast<CommandLoadSessionState*>(_state.get());

  return _state;
}

ActionState::ptr CommandLoadSessionAction::performRedo(ActionState::ptr _state){
  //  CommandLoadSessionState *state = assert_cast<CommandLoadSessionState*>(_state.get());

    return _state;
}

bool CommandLoadSessionAction::canUndo() {
  return false;
}

bool CommandLoadSessionAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
