/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ElementDbAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include headers that implement a archive in simple text format
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>

#include "CodePatterns/MemDebug.hpp"

#include "config.hpp"
#include "Element/element.hpp"    // we need element because of serialization!
#include "Element/ion.hpp"    // we need element because of serialization!
#include "Element/periodentafel.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <string>

#include "Actions/CommandAction/ElementDbAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "ElementDbAction.def"
#include "Actions/Action_impl_pre.hpp"

/** =========== define the function ====================== */
ActionState::ptr CommandElementDbAction::performCall() {
  std::ostringstream usage;

  periodentafel *&periode = World::getInstance().getPeriode();

  // create undo state
  std::stringstream undostream;
  boost::archive::text_oarchive oa(undostream);
  oa << periode;
  CommandElementDbState *UndoState =
      new CommandElementDbState(
          undostream.str(),
          params
          );

  // get the path
  // TODO: Make databasepath a std::string
  config *configuration = World::getInstance().getConfig();
  strcpy(configuration->databasepath, params.databasepath.get().branch_path().string().c_str());

  // load table
  periode->CleanupPeriodtable();
  if (periode->LoadPeriodentafel(configuration->databasepath)) {
    STATUS("Element list loaded successfully.");
    //periode->Output();
    return ActionState::ptr(UndoState);
  } else {
    STATUS("Element list loading failed.");
    delete UndoState;
    return Action::failure;
  }
}

ActionState::ptr CommandElementDbAction::performUndo(ActionState::ptr _state) {
  CommandElementDbState *state = assert_cast<CommandElementDbState*>(_state.get());

  periodentafel *periode;

  std::stringstream undostream(state->undostring);
  boost::archive::text_iarchive ia(undostream);
  ia >> periode;

  delete World::getInstance().getPeriode();
  World::getInstance().getPeriode() = periode;

  return ActionState::ptr(_state);
}

ActionState::ptr CommandElementDbAction::performRedo(ActionState::ptr _state){
  CommandElementDbState *state = assert_cast<CommandElementDbState*>(_state.get());

  // get the path
  // TODO: Make databasepath a std::string
  config *configuration = World::getInstance().getConfig();
  strcpy(configuration->databasepath, state->params.databasepath.get().branch_path().string().c_str());

  // load table
  periodentafel *&periode = World::getInstance().getPeriode();
  periode->CleanupPeriodtable();
  if (periode->LoadPeriodentafel(configuration->databasepath)) {
    STATUS("Redoing Element list loaded successfully.");
    //periode->Output();
    return ActionState::ptr(_state);
  } else {
    STATUS("Redoing Element list loading failed.");
    return Action::failure;
  }
}

bool CommandElementDbAction::canUndo() {
  return true;
}

bool CommandElementDbAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
