/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * RemoveAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Actions/UndoRedoHelpers.hpp"
#include "Atom/atom.hpp"
#include "Atom/AtomicInfo.hpp"
#include "Descriptors/AtomDescriptor.hpp"
#include "CodePatterns/Log.hpp"
#include "molecule.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include "Actions/AtomAction/RemoveAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "RemoveAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr AtomRemoveAction::performCall() {
  // create undo state
  std::vector<AtomicInfo> Walkers;
  for (World::AtomSelectionConstIterator iter = World::getInstance().beginAtomSelection();
      iter != World::getInstance().endAtomSelection();
      ++iter) {
    Walkers.push_back(AtomicInfo(*(iter->second)));
  }
  AtomRemoveState *UndoState = new AtomRemoveState(Walkers, params);

  // remove all selected atoms
  for (World::AtomSelectionConstIterator iter = World::getInstance().beginAtomSelection();
      iter != World::getInstance().endAtomSelection();
      iter = World::getInstance().beginAtomSelection()) {
    LOG(1, "Removing atom " << (iter->second)->getId() << ".");
    World::getInstance().destroyAtom((iter->second));
  }
  return ActionState::ptr(UndoState);
}

ActionState::ptr AtomRemoveAction::performUndo(ActionState::ptr _state) {
  AtomRemoveState *state = assert_cast<AtomRemoveState*>(_state.get());

  // add all removed atoms again
  if (AddAtomsFromAtomicInfo(state->Walkers))
    return ActionState::ptr(_state);
  else {
    STATUS("Failed to re-add removed atoms.");
    return Action::failure;
  }
}

ActionState::ptr AtomRemoveAction::performRedo(ActionState::ptr _state){
  AtomRemoveState *state = assert_cast<AtomRemoveState*>(_state.get());

  // simple remove again all previously added atoms
  RemoveAtomsFromAtomicInfo(state->Walkers);

  return ActionState::ptr(_state);
}

bool AtomRemoveAction::canUndo() {
  return true;
}

bool AtomRemoveAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
