/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * AddAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/AtomIdDescriptor.hpp"
#include "Atom/atom.hpp"
#include "Element/element.hpp"
#include "CodePatterns/Log.hpp"
#include "molecule.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include "Actions/AtomAction/AddAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "AddAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr AtomAddAction::performCall() {
  // execute action
  atom * first = World::getInstance().createAtom();
  first->setType(params.elemental.get());
  first->setPosition(params.position.get());
  LOG(1, "Adding new atom with element " << first->getType()->getName() << " at " << (first->getPosition()) << ".");
  // TODO: remove when all of World's atoms are stored.
  std::vector<molecule *> molecules = World::getInstance().getAllMolecules();
  if (!molecules.empty()) {
    std::vector<molecule *>::iterator iter = molecules.begin();
    (*iter)->AddAtom(first);
  }
  return ActionState::ptr(new AtomAddState(first->getId(), params));
}

ActionState::ptr AtomAddAction::performUndo(ActionState::ptr _state) {
  AtomAddState *state = assert_cast<AtomAddState*>(_state.get());

  LOG(1, "Removing atom with id " << state->id << ".");
  World::getInstance().destroyAtom(state->id);

  return ActionState::ptr(_state);
}

ActionState::ptr AtomAddAction::performRedo(ActionState::ptr _state){
  AtomAddState *state = assert_cast<AtomAddState*>(_state.get());

  atom * first = World::getInstance().createAtom();
  first->setType(state->params.elemental.get());
  first->setPosition(state->params.position.get());
  LOG(1, "Re-adding new atom with element " << state->params.elemental.get()->getName() << " at " << state->params.position.get() << ".");
  // TODO: remove when all of World's atoms are stored.
  std::vector<molecule *> molecules = World::getInstance().getAllMolecules();
  if (!molecules.empty()) {
    std::vector<molecule *>::iterator iter = molecules.begin();
    (*iter)->AddAtom(first);
  }
  if (first->getId() != state->id)
    if (!first->changeId(state->id)) {
      STATUS("Could not change atom id "+toString(first->getId())+"->"+toString(state->id)+".");
      return Action::failure;
    }

  return ActionState::ptr(_state);
}

bool AtomAddAction::canUndo() {
  return true;
}

bool AtomAddAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
