/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * DipoleCorrelationAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Analysis/analysis_correlation.hpp"
#include "CodePatterns/Log.hpp"
#include "Element/element.hpp"
#include "Element/periodentafel.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace MoleCuilder;

#include "Actions/AnalysisAction/DipoleCorrelationAction.hpp"

// and construct the stuff
#include "DipoleCorrelationAction.def"
#include "Action_impl_pre.hpp"

/** =========== define the function ====================== */
ActionState::ptr AnalysisDipoleCorrelationAction::performCall() {
  //int ranges[3] = {1, 1, 1};
  ofstream output;
  ofstream binoutput;
  string type;
  BinPairMap *binmap = NULL;

  // execute action
  output.open(params.outputname.get().string().c_str());
  binoutput.open(params.binoutputname.get().string().c_str());
  DipoleCorrelationMap *correlationmap = NULL;
  std::vector<molecule*> molecules = World::getInstance().getSelectedMolecules();
  STATUS("There are "+toString(molecules.size())+" selected molecules.");
  ASSERT(!params.periodic.get(), "AnalysisDipoleCorrelationAction() - periodic case not implemented.");
  correlationmap = DipoleCorrelation(molecules);
  OutputCorrelationMap<DipoleCorrelationMap>(&output, correlationmap, OutputDipoleCorrelation_Header, OutputDipoleCorrelation_Value);
  binmap = BinData( correlationmap, params.BinWidth.get(), params.BinStart.get(), params.BinEnd.get() );
  OutputCorrelationMap<BinPairMap> ( &binoutput, binmap, OutputCorrelation_Header, OutputCorrelation_Value );
  delete(binmap);
  delete(correlationmap);
  output.close();
  binoutput.close();
  return Action::success;
}

ActionState::ptr AnalysisDipoleCorrelationAction::performUndo(ActionState::ptr _state) {
  return Action::success;
}

ActionState::ptr AnalysisDipoleCorrelationAction::performRedo(ActionState::ptr _state){
  return Action::success;
}

bool AnalysisDipoleCorrelationAction::canUndo() {
  return true;
}

bool AnalysisDipoleCorrelationAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
