/*
 * ActionStatusList.hpp
 *
 *  Created on: Jun 19, 2014
 *      Author: heber
 */


#ifndef ACTIONSTATUSLIST_HPP_
#define ACTIONSTATUSLIST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/thread.hpp>
#include <list>
#include <string>

#include "CodePatterns/Assert.hpp"
#include "CodePatterns/Observer/Observable.hpp"

namespace MoleCuilder {

class ActionQueue;

/** Class contains list of status messages and can be observed by UI's StatusBars.
 *
 * It always belongs to the ActionQueue.
 *
 */
class ActionStatusList : public Observable
{
  //!> only ActionQueue may create this class
  friend class ActionQueue;
private:
  /** Constructor for class ActionStatusList.
   *
   */
  ActionStatusList();

  /** Destructor for class ActionStatusList.
   *
   */
  virtual ~ActionStatusList();

  /** Function to push a message to the list.
   *
   * This is only accessible to ActionQueue to prevent anything but Actions
   * to give a Status message. ActionQueue::pushStatus() has access.
   *
   * \param _msg message to push
   */
  void pushMessage(const std::string &_msg);

public:
  /** Get first message to enter list and remove from list.
   *
   * \return first message in list
   */
  std::string popFirstMessage();

  /** Get number of messages in the list.
   *
   * \return number of messages
   */
  size_t size() const
  {
    return m_StatusList.size();
  }

  //!> enumeration of all notification channels
  enum NotificationType {
    StatusAdded,  // new status message added
    NotificationType_MAX  // denotes the maximum of available notification types
  };

private:
  //!> typedef for the list of status message
  typedef std::list<std::string> StatusList_t;
  //> list of status message
  StatusList_t m_StatusList;
  //!> internal mutex to synchronize access to queue
  boost::mutex mtx_queue;
};

}

#endif /* ACTIONSTATUSLIST_HPP_ */
