/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2014 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ActionStatusList.cpp
 *
 *  Created on: Jun 19, 2014
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"
#include "CodePatterns/Observer/Channels.hpp"

#include "ActionStatusList.hpp"

using namespace MoleCuilder;

ActionStatusList::ActionStatusList() :
  Observable("ActionStatusList")
{
  Channels *OurChannel = new Channels;
  NotificationChannels.insert( std::make_pair(static_cast<Observable *>(this), OurChannel) );
  // add instance for each notification type
  for (size_t type = 0; type < NotificationType_MAX; ++type)
    OurChannel->addChannel(type);
}

ActionStatusList::~ActionStatusList()
{
  // subjectKilled() informs all observers that we go offline: Fetch all remaining messages
}

std::string ActionStatusList::popFirstMessage()
{
  mtx_queue.lock();
  ASSERT( !m_StatusList.empty(),
      "ActionStatusList::popFirstMessage() - message list is empty.");
  std::string message = m_StatusList.front();
  m_StatusList.pop_front();
  mtx_queue.unlock();
  return message;
}

void ActionStatusList::pushMessage(const std::string &_msg)
{
  mtx_queue.lock();
  OBSERVE;
  NOTIFY(ActionStatusList::StatusAdded);
  m_StatusList.push_back(_msg);
  mtx_queue.unlock();
}
